/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.persist.ProblemPersistenceException;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.ProblemOpeningException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.ar.CommonServiceAnalysisRoutine;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProblemOpenAnalysisRoutine
extends CommonServiceAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPAPOART";
    private static final String TRACE_MASKF = "XPAPOARF";
    private static final String TRACE_MASKD = "XPAPOARD";

    public ProblemOpenAnalysisRoutine() {
        Trace.trace(TRACE_MASKD, "ProblemOpenAnalysisRoutine.<init> entry");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKF, "--> ProblemOpenAnalysisRoutine.analyze()");
        ProblemManager thePM = null;
        try {
            thePM = ProblemManager.getProblemManager();
        }
        catch (ProblemPersistenceException e) {
            Trace.trace(TRACE_MASKD, "Got an exception. Who cares!!!!");
        }
        catch (PersistenceNotInitializedException e) {
            // empty catch block
        }
        IncidentPool thePool = ProblemOpenAnalysisRoutine.getAnalyzingIncidentPool(((CommonServiceAREvent)event).getIncidentPoolId());
        ArrayList sortList = new ArrayList();
        CommonServiceIncident anIncident = null;
        Iterator poolIterator = thePool.iterator();
        List knownProblems = thePM.getAllProblems();
        Trace.trace(TRACE_MASKD, "loop through the problems we have in the pool");
        while (poolIterator.hasNext()) {
            anIncident = (CommonServiceIncident)poolIterator.next();
            CommonProblem poolProblem = anIncident.getProblem();
            try {
                StringBuffer xmled = new StringBuffer();
                Trace.trace(TRACE_MASKF, "working with problem uuid = " + poolProblem.getUniqueKey());
                if (poolProblem.isDuplicateOf()) {
                    Trace.trace(TRACE_MASKF, "Adding a duplicate problem the from the pool number = " + poolProblem.getProblemNumber());
                    thePM.addProblem(poolProblem);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "open a problem the from the pool number = " + poolProblem.getProblemNumber());
                thePM.open(poolProblem);
            }
            catch (PropertyVetoException e) {
                Trace.trace(TRACE_MASKF, "got an exception");
                Trace.trace(TRACE_MASKF, e);
            }
            catch (ProblemOpeningException e) {
                Trace.trace(TRACE_MASKF, "got an exception");
                Trace.trace(TRACE_MASKF, e);
            }
            catch (ProblemPersistenceException e) {
                Trace.trace(TRACE_MASKF, "got an exception");
                Trace.trace(TRACE_MASKF, e);
            }
            catch (PersistenceNotInitializedException e) {
                Trace.trace(TRACE_MASKF, "got an exception");
                Trace.trace(TRACE_MASKF, e);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "got an exception");
                Trace.trace(TRACE_MASKF, e);
            }
        }
        Trace.trace(TRACE_MASKF, "remove the pool");
        CommonServiceAnalysisRoutine.removeAnalyzingIncidentPool(thePool.getPoolId());
        Trace.trace(TRACE_MASKF, "<-- ProblemOpenAnalysisRoutine.analyze()");
    }
}

